using System;
using System.IO;
using DynaPDF;

namespace edit_text
{
	class Edit_Text
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         // We ignore warnings like "Font not found!" since this case is handled in the function CPDFEditText.SetFont().
         if ((ErrType & (uint)TErrType.E_WARNING) != 0) return 0;
         Console.WriteLine("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            // We import the contents only, without conversion of pages to templates
            pdf.SetImportFlags(TImportFlags.ifContentOnly | TImportFlags.ifImportAsPage);
            pdf.SetImportFlags2(TImportFlags2.if2UseProxy);
            if (pdf.OpenImportFile("../../../../dynapdf_help.pdf", DynaPDF.TPwdType.ptOpen, null) < 0)
            {
               Console.Read();
               return;
            }
            pdf.ImportPDFFile(1, 1.0, 1.0);
            pdf.CloseImportFile();

            CPDFContentParser ctx = new CPDFContentParser(pdf, TOptimizeFlags.ofDefault, null);

            TContent    content = new TContent();
            String  searchText  = "PDF"; // This string occurs of course very often in the help file
            String  replaceText = "XDF"; // Just an example. Use also a longer or shorter string to see what happens...
            TTextSelection sel  = new TTextSelection();
            TTextSelection curr;

            int pageCount = pdf.GetPageCount();
            for (int i = 1; i <= pageCount; i++)
            {
               // The flag cpfEnableTextSelection is required. Otherwise no text can be found.
               if (ctx.ParsePage(i, TContentParseFlags.cpfEnableTextSelection, ref content))
               {
                  curr = null;
                  // Replace all occurences of "PDF" with "XDF" (case insensitive).
                  while (ctx.FindText(TSearchType.stCaseInSensitive, curr, searchText, sel))
                  {
                     // Set the replacement string to an empty string one time to see how surrounding text will be handled...
                     // With psrSetAltFont() you can also set the preferred alternate font to output the new text if the
                     // original font is not available on the system.
                     ctx.ReplaceSelText(TReplaceTextFlags.rtfDefault, sel, replaceText);
                     curr = sel;
                  }
                  ctx.WriteToPage(TOptimizeFlags.ofDefault, null);
               }
            }
            ctx = null;
            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (pdf.OpenOutputFile(filePath) && pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }
         catch(Exception e)
         {
            // DynaPDF error messages are already handled!
            if (e.Message != "-1") Console.Write(e.Message);
         }
         Console.Read();
		}
	}
}
